// Autor: Gustav Matula

#include <cstdio>
#include <cstring>

#include <vector>
#include <iostream>
#include <algorithm>

using namespace std;
typedef long long llint;
const llint inf = 1000000000000000000LL;

#define FOR(i, a, b) for (int i = (a); i < (b); ++i)
#define REP(i, n) FOR(i, 0, n)

#define TRACE(x) cerr << #x << " = " << x << endl
#define _ << " _ " <<

typedef pair< llint, llint > Cell;

const int MAXN = 200005;

llint miny[MAXN], maxy[MAXN];

int main(void) 
{
  int N;
  scanf("%d", &N);

  vector< Cell > e;

  REP(i, N) {
    int x, y;
    scanf("%d%d", &x, &y);
    e.push_back({x, y});
  }

  sort(e.begin(), e.end());

  miny[N] = inf;
  maxy[N] = 0;

  for (int i = N - 1; i >= 0; --i) {
    miny[i] = min(miny[i + 1], e[i].second);
    maxy[i] = max(maxy[i + 1], e[i].second);
  }

  llint cminy = inf;
  llint cmaxy = 0;

  vector< pair< llint, pair< llint, llint > > > slabs;

  for (int i = 0, j; i < N; i = j) {
    for (j = i + 1; j < N && e[j].first == e[i].first; ++j);

    llint lo = max(cminy, miny[j]);
    llint hi = min(cmaxy, maxy[j]);
    slabs.push_back({e[i].first, {lo + 1, hi - 1}});

    FOR(k, i, j) {
      cminy = min(cminy, e[k].second);
      cmaxy = max(cmaxy, e[k].second);
    }

    lo = max(cminy, miny[j]);
    hi = min(cmaxy, maxy[j]);

    if (e[j].first - e[i].first >= 2)
      slabs.push_back({e[i].first + 1, {lo + 1, hi - 1}});
    if (e[j].first - e[i].first >= 3)
      slabs.push_back({e[j].first - 1, {lo + 1, hi - 1}});
  }

  sort(slabs.begin(), slabs.end());

  llint lo = 0, hi = 1e9;
  while (lo < hi) {
    llint mid = (lo + hi + 1) / 2;
    bool ok = false;

    for (int i = 0, j = 0; i < (int)slabs.size(); ++i) {
      while (slabs[i].first - slabs[j].first + 1 > mid) ++j;

      llint lo = max(slabs[i].second.first, slabs[j].second.first);
      llint hi = min(slabs[i].second.second, slabs[j].second.second);

      if (hi - lo + 1 >= mid) {
	ok = true;
	break;
      }
    }

    if (ok) lo = mid;
    else hi = mid - 1;
  }

  printf("%lld\n", lo);

  return 0;
}
